/* dateMenu.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* exported DateMenuButton */

const { Clutter, GObject, St } = imports.gi;

const Main = imports.ui.main;

const KEY_SHOW_EVENTS_ICON = 'show-events-icon';

const EventsIndicator = GObject.registerClass(
class EventsIndicator extends St.Icon {
    _init(settings) {
        super._init({
            icon_name: 'org.gnome.Calendar-symbolic',
            icon_size: 16,
            visible: false,
            y_expand: true,
            y_align: Clutter.ActorAlign.CENTER,
        });
        Main.panel.statusArea.dateMenu._eventsItem.setDate(new Date());
        this._settings = settings;
        this._settingsChangedId = this._settings.connect('changed::%s'.format(KEY_SHOW_EVENTS_ICON), this._updateVisibility.bind(this));
        this._eventSourceChangedId = Main.panel.statusArea.dateMenu._eventSource.connect('changed', this._updateVisibility.bind(this));
        this._selectedDateChangedId = Main.panel.statusArea.dateMenu._calendar.connect('selected-date-changed', this._updateVisibility.bind(this));
        this._updateVisibility();
        this._openStateChangedId = Main.panel.statusArea.dateMenu.menu.connect('open-state-changed', (menu, isOpen) => {
            // Whenever the menu is closed, select today
            if (!isOpen) {
                let now = new Date();
                Main.panel.statusArea.dateMenu._calendar.setDate(now);
                Main.panel.statusArea.dateMenu._date.setDate(now);
                Main.panel.statusArea.dateMenu._eventsItem.setDate(now);
            }
        });
    }

    _updateVisibility() {
        let showEventsIcon = this._settings.get_boolean(KEY_SHOW_EVENTS_ICON);
        let events = Main.panel.statusArea.dateMenu._eventsItem._eventsList.get_children();
        let numEvents = events.length;
        if (numEvents === 1 && events[0].style_class === 'event-placeholder') numEvents = 0;
        this.visible = showEventsIcon && numEvents > 0;
    }

    destroy() {
        Main.panel.statusArea.dateMenu.menu.disconnect(this._openStateChangedId);
        Main.panel.statusArea.dateMenu._calendar.disconnect(this._selectedDateChangedId);
        Main.panel.statusArea.dateMenu._eventSource.disconnect(this._eventSourceChangedId);
        this._settings.disconnect(this._settingsChangedId);
        super.destroy();
    }
});

class DateMenuButton {
    constructor(settings) {
        this._indicator = new EventsIndicator(settings);
        let pos = Main.panel.statusArea.dateMenu.get_children()[0].get_n_children();
        Main.panel.statusArea.dateMenu.get_children()[0].insert_child_at_index(this._indicator, pos - 1);
    }

    destroy() {
        Main.panel.statusArea.dateMenu.get_children()[0].remove_child(this._indicator);
        this._indicator.destroy();
    }
}
